﻿using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace Low_Memory_Candy
{
    class Bar
    {
        public Vector2 pos;
        public Texture2D tex;
        public Color color;
        private Rectangle rect;

        public Bar(Texture2D texture, Vector2 position)
        {
            this.tex = texture;
            this.pos = position;
            updateSize(100); // Set all variables
        }

        public void updateSize(int percent)
        {
            if (percent < 0) percent = 0;
            int width = (tex.Width / 100) * percent; // GEHEEL / 100 * PROCENT = NIEUWE WAARDE DANKJE ECONOMIE!
            this.color = new Color((255 / (percent + 10 / 10)) * 25, (255 / 100) * percent + 1, 0);
            this.rect = new Rectangle((int)pos.X, (int)pos.Y, width, tex.Height);
        }

        public void draw(SpriteBatch sb)
        {
            sb.Draw(tex, rect, color);
        }
    }
}
